using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmPatientRecordReport
	/// </summary>
	public class FrmPatientRecordReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.PatientRecordReport _report;
		//
		private System.Windows.Forms.Button btnPrint;
        private System.Windows.Forms.Button btnCancel;
        private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.PrintDialog printDialog1;
        private PictureBox pictureBox2;
        private GroupBox grpImage1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvPatientHistoryReport;
		private System.ComponentModel.IContainer components = null;
        DataSet _dsReportData = new DataSet();

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="report"></param>
		public FrmPatientRecordReport(BOL.PatientRecordReport report)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			this._report = report;
			//
			SetComponentProperties();
			//
			using (new WaitCursor())
			{
				this.CreateReport();
			}

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmPatientRecordReport));
            this.btnPrint = new System.Windows.Forms.Button();
            this.btnCancel = new System.Windows.Forms.Button();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.grpImage1 = new System.Windows.Forms.GroupBox();
            this.rvPatientHistoryReport = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.grpImage1.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Patient History Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 466);
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.PrintClick);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.CloseClick);
            // 
            // pictureBox1
            // 
            this.pictureBox1.Location = new System.Drawing.Point(0, 0);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(100, 50);
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(4, 8);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(45, 45);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox2.TabIndex = 1;
            this.pictureBox2.TabStop = false;
            // 
            // grpImage1
            // 
            this.grpImage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage1.Controls.Add(this.pictureBox2);
            this.grpImage1.Location = new System.Drawing.Point(4, 32);
            this.grpImage1.Name = "grpImage1";
            this.grpImage1.Size = new System.Drawing.Size(52, 412);
            this.grpImage1.TabIndex = 4;
            this.grpImage1.TabStop = false;
            // 
            // rvPatientHistoryReport
            // 
            this.rvPatientHistoryReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvPatientHistoryReport.Location = new System.Drawing.Point(60, 37);
            this.rvPatientHistoryReport.Name = "rvPatientHistoryReport";
            this.rvPatientHistoryReport.Size = new System.Drawing.Size(579, 405);
            this.rvPatientHistoryReport.TabIndex = 6;
            // 
            // FrmPatientRecordReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 480);
            this.Controls.Add(this.rvPatientHistoryReport);
            this.Controls.Add(this.grpImage1);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Patient_History_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(650, 507);
            this.Name = "FrmPatientRecordReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Patient History Report";
            this.Load += new System.EventHandler(this.FrmPatientRecordReport_Load);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage1, 0);
            this.Controls.SetChildIndex(this.rvPatientHistoryReport, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            this.grpImage1.ResumeLayout(false);
            this.grpImage1.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC101.FrmPatientRecordReport());
			//
			this.SetThisToolTip(this.btnPrint,Common.StrRes.Tooltips.Common.Print());
            BOL.VbecsReport.SetUpReportButtons(this.rvPatientHistoryReport);
        }

		private void CreateReport()
		{
			_dsReportData = this._report.GetPatientRecordReport();

            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._report.ReportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReportData.Tables["ReportSections"].Rows.Count > 0)
            {
                reportSourceMain.Name = "PatientHistoryReportDataSet";
                reportSourceMain.Value = _dsReportData.Tables["ReportSections"];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }
            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientHistoryReportMain.rdlc");
            Stream streamPatientDemographic = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientDemographicHistory.rdlc");
            Stream streamPatientAboRH = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientAboRHHistory.rdlc");
            Stream streamPatientSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientSpecimenHistory.rdlc");
            Stream streamPatientTesting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientTestingHistory.rdlc");
            Stream streamPatientAssignment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientUnitAssignmentHistory.rdlc");
            Stream streamPatientTransfusion = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientTransfusionHistory.rdlc");
            Stream streamPatientTransfusionReaction = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientTransfusionReactionHistory.rdlc");
            Stream streamPatientTransfusionRequirements = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientTransfusionRequirementsHistory.rdlc");
            Stream streamPatientSpecialInstructions = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientSpecialInstructionsHistory.rdlc");
            Stream streamExceptionPatientAboRh = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAboRh.rdlc");
            Stream streamExceptionPatientAboRhDiscrepancy = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAboRhDiscrepancy.rdlc");
            Stream streamExceptionPatientAntigenDiscrepancy = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAntigenDiscrepancy.rdlc");
            Stream streamExceptionPatientTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientTest.rdlc");
            Stream streamExceptionPatientTestInactivated = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientTestInactivated.rdlc");
            Stream streamExceptionQCNotPerformed = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQCNotPerformed.rdlc");
            Stream streamExceptionQC = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQC.rdlc");
            Stream streamExceptionReflexTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReflexTest.rdlc");
            Stream streamExceptionSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionSpecimen.rdlc");
            Stream streamExceptionUnitSelection = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitSelection.rdlc");
            Stream streamExceptionTrwSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTrwSpecimen.rdlc");
            Stream streamExceptionTransfusionReactionWorkup = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTransfusionReactionWorkup.rdlc");
            Stream streamExceptionCautionTagBTRFPrinting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionCautionTagBTRFPrinting.rdlc");
            Stream streamExceptionReturnIssuedUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReturnIssuedUnit.rdlc");
            Stream streamExceptionTransfusion = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTransfusion.rdlc");
            Stream streamExceptionUnitIssue = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitIssue.rdlc");
            Stream streamExceptionEmergencyIssueOrder = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionEmergencyIssueOrder.rdlc");
            Stream streamExceptionUnitERIssuedTestingProblem = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitERIssuedTestingProblem.rdlc");
            Stream streamExceptionPatientRestriction = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientRestriction.rdlc");

            this.rvPatientHistoryReport.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);
            
            this.rvPatientHistoryReport.LocalReport.DataSources.Add(reportSourceMain);
            this.rvPatientHistoryReport.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvPatientHistoryReport.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvPatientHistoryReport.LocalReport.LoadReportDefinition(stream);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientDemographicHistory", streamPatientDemographic);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientAboRHHistory", streamPatientAboRH);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientSpecimenHistory", streamPatientSpecimen);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientTestingHistory", streamPatientTesting);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientUnitAssignmentHistory", streamPatientAssignment);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientTransfusionHistory", streamPatientTransfusion);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientTransfusionReactionHistory", streamPatientTransfusionReaction);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientTransfusionRequirementsHistory", streamPatientTransfusionRequirements);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("PatientSpecialInstructionsHistory", streamPatientSpecialInstructions);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionPatientAboRh", streamExceptionPatientAboRh);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionPatientAboRhDiscrepancy", streamExceptionPatientAboRhDiscrepancy);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionPatientAntigenDiscrepancy", streamExceptionPatientAntigenDiscrepancy);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionPatientTest", streamExceptionPatientTest);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionPatientTestInactivated", streamExceptionPatientTestInactivated);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionQCNotPerformed", streamExceptionQCNotPerformed);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionQC", streamExceptionQC);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionReflexTest", streamExceptionReflexTest);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionSpecimen", streamExceptionSpecimen);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionUnitSelection", streamExceptionUnitSelection);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionTrwSpecimen", streamExceptionTrwSpecimen);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionTransfusionReactionWorkup", streamExceptionTransfusionReactionWorkup);
            //CR 3355 Fixed spelling of the CautionTag Exception subreport
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionCautionTagBTRFPrinting", streamExceptionCautionTagBTRFPrinting);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionReturnIssuedUnit", streamExceptionReturnIssuedUnit);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionTransfusion", streamExceptionTransfusion);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionUnitIssue", streamExceptionUnitIssue);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionEmergencyIssueOrder", streamExceptionEmergencyIssueOrder);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionUnitERIssuedTestingProblem", streamExceptionUnitERIssuedTestingProblem);
            this.rvPatientHistoryReport.LocalReport.LoadSubreportDefinition("ExceptionPatientRestriction", streamExceptionPatientRestriction);

		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "PatientDemographicHistory" || e.DataSourceNames[0].ToString() == "PatientDemographicHistoryDataSet")
            {
                ReportDataSource reportSourcePatientDemographic = new ReportDataSource();
                if (this._report.IncludePatientDemographics)
                {
                    reportSourcePatientDemographic.Name = "PatientDemographicHistoryDataSet";
                    reportSourcePatientDemographic.Value = this._dsReportData.Tables[Common.VbecsTables.Patient.TableName];
                }
                e.DataSources.Add(reportSourcePatientDemographic);
            }
            else if (e.ReportPath == "PatientAboRHHistory" || e.DataSourceNames[0].ToString() == "PatientAboRHHistoryDataSet")
            {
                ReportDataSource reportSourcePatientAboRH = new ReportDataSource();
                if (this._report.IncludePatientDemographics)
                {
                    reportSourcePatientAboRH.Name = "PatientAboRHHistoryDataSet";
                    reportSourcePatientAboRH.Value = this._dsReportData.Tables[Common.VbecsTables.Compatibility.PatientAboRh];
                }
                e.DataSources.Add(reportSourcePatientAboRH);
            }
            else if (e.ReportPath == "PatientSpecimenHistory" || e.DataSourceNames[0].ToString() == "PatientSpecimenHistoryDataSet")
            {
                ReportDataSource reportSourcePatientSpecimen = new ReportDataSource();
                if (this._report.IncludePatientSpecimens)
                {
                    reportSourcePatientSpecimen.Name = "PatientSpecimenHistoryDataSet";
                    reportSourcePatientSpecimen.Value = this._dsReportData.Tables[Common.VbecsTables.PatientSpecimen.TableName];
                }
                e.DataSources.Add(reportSourcePatientSpecimen);
            }
            else if (e.ReportPath == "PatientTestingHistory" || e.DataSourceNames[0].ToString() == "PatientTestingHistoryDataSet")
            {
                ReportDataSource reportSourcePatientTesting = new ReportDataSource();
                if (this._report.IncludePatientTesting)
                {
                    reportSourcePatientTesting.Name = "PatientTestingHistoryDataSet";
                    reportSourcePatientTesting.Value = this._dsReportData.Tables[Common.VbecsTables.SpecimenTest.TableName];
                }
                e.DataSources.Add(reportSourcePatientTesting);
            }
            else if (e.ReportPath == "PatientUnitAssignmentHistory" || e.DataSourceNames[0].ToString() == "PatientUnitAssignmentHistoryDataSet")
            {
                ReportDataSource reportSourcePatientAssignment = new ReportDataSource();
                if (this._report.IncludePatientUnitAssignments)
                {
                    reportSourcePatientAssignment.Name = "PatientUnitAssignmentHistoryDataSet";
                    reportSourcePatientAssignment.Value = this._dsReportData.Tables[Common.VbecsTables.OrderedUnit.TableName];
                }
                e.DataSources.Add(reportSourcePatientAssignment);
            }
            else if (e.ReportPath == "PatientTransfusionHistory" || e.DataSourceNames[0].ToString() == "PatientTransfusionHistoryDataSet")
            {
                ReportDataSource reportSourcePatientTransfusion = new ReportDataSource();
                if (this._report.IncludePatientTransfusions)
                {
                    reportSourcePatientTransfusion.Name = "PatientTransfusionHistoryDataSet";
                    reportSourcePatientTransfusion.Value = this._dsReportData.Tables[Common.VbecsTables.PatientTransfusion.TableName];
                }
                e.DataSources.Add(reportSourcePatientTransfusion);
            }
            else if (e.ReportPath == "PatientTransfusionReactionHistory" || e.DataSourceNames[0].ToString() == "PatientTransfusionReactionHistoryDataSet")
            {
                ReportDataSource reportSourcePatientTransfusionReaction = new ReportDataSource();
                ReportDataSource reportSourceReportSections = new ReportDataSource();
                if (this._report.IncludePatientTransfusionReactions)
                {
                    reportSourcePatientTransfusionReaction.Name = "PatientTransfusionReactionHistoryDataSet";
                    reportSourcePatientTransfusionReaction.Value = this._dsReportData.Tables[Common.VbecsTables.PatientTransfusionReaction.TableName];
                    reportSourceReportSections.Name = "PatientHistoryReportDataSet";
                    reportSourceReportSections.Value = this._dsReportData.Tables["ReportSections"];
                }
                e.DataSources.Add(reportSourcePatientTransfusionReaction);
                e.DataSources.Add(reportSourceReportSections);
            }
            else if (e.ReportPath == "PatientTransfusionRequirementsHistory" || e.DataSourceNames[0].ToString() == "PatientTransfusionRequirementsHistoryDataSet")
            {
                ReportDataSource reportSourcePatientTransfusionRequirements = new ReportDataSource();
                if (this._report.IncludePatientTransfusionRequirements)
                {
                    reportSourcePatientTransfusionRequirements.Name = "PatientTransfusionRequirementsHistoryDataSet";
                    reportSourcePatientTransfusionRequirements.Value = this._dsReportData.Tables[Common.VbecsTables.PatientTransfusionRequirement.TableName];
                }
                e.DataSources.Add(reportSourcePatientTransfusionRequirements);
            }
            else if (e.ReportPath == "PatientSpecialInstructionsHistory" || e.DataSourceNames[0].ToString() == "PatientSpecialInstructionsHistoryDataSet")
            {
                ReportDataSource reportSourcePatientSpecialInstructions = new ReportDataSource();
                if (this._report.IncludePatientSpecialInstructions)
                {
                    reportSourcePatientSpecialInstructions.Name = "PatientSpecialInstructionsHistoryDataSet";
                    reportSourcePatientSpecialInstructions.Value = this._dsReportData.Tables[Common.VbecsTables.PatientSpecialInstruction.TableName];
                }
                e.DataSources.Add(reportSourcePatientSpecialInstructions);
            }
            else if (e.ReportPath == "ExceptionPatientAboRh" || e.DataSourceNames[0].ToString() == "ExceptionPatientAboRhDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAboRh = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientAboRh.Name = "ExceptionPatientAboRhDataSet";
                    reportSourceExceptionPatientAboRh.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRh.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientAboRh);
            }
            else if (e.ReportPath == "ExceptionPatientAboRhDiscrepancy" || e.DataSourceNames[0].ToString() == "ExceptionPatientAboRhDiscrepancyDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAboRhDiscrepancy = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientAboRhDiscrepancy.Name = "ExceptionPatientAboRhDiscrepancyDataSet";
                    reportSourceExceptionPatientAboRhDiscrepancy.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientAboRhDiscrepancy);
            }
            else if (e.ReportPath == "ExceptionPatientAntigenDiscrepancy" || e.DataSourceNames[0].ToString() == "ExceptionPatientAntigenDiscrepancyDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAntigenDiscrepancy = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientAntigenDiscrepancy.Name = "ExceptionPatientAntigenDiscrepancyDataSet";
                    reportSourceExceptionPatientAntigenDiscrepancy.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientAntigenDiscrepancy);
            }
            else if (e.ReportPath == "ExceptionPatientTest" || e.DataSourceNames[0].ToString() == "ExceptionPatientTestDataSet")
            {
                ReportDataSource reportSourceExceptionPatientTest = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientTest.Name = "ExceptionPatientTestDataSet";
                    reportSourceExceptionPatientTest.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientTest.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientTest);
            }
            else if (e.ReportPath == "ExceptionPatientTestInactivated" || e.DataSourceNames[0].ToString() == "ExceptionPatientTestInactivatedDataSet")
            {
                ReportDataSource reportSourceExceptionPatientTestInactivated = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientTestInactivated.Name = "ExceptionPatientTestInactivatedDataSet";
                    reportSourceExceptionPatientTestInactivated.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientTestInactivated.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientTestInactivated);
            }
            else if (e.ReportPath == "ExceptionQCNotPerformed" || e.DataSourceNames[0].ToString() == "ExceptionQCNotPerformedDataSet")
            {
                ReportDataSource reportSourceExceptionQCNotPerformed = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionQCNotPerformed.Name = "ExceptionQCNotPerformedDataSet";
                    reportSourceExceptionQCNotPerformed.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportQCNotPerformed.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionQCNotPerformed);
            }
            else if (e.ReportPath == "ExceptionQC" || e.DataSourceNames[0].ToString() == "ExceptionQCDataSet")
            {
                ReportDataSource reportSourceExceptionQC = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionQC.Name = "ExceptionQCDataSet";
                    reportSourceExceptionQC.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportQC.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionQC);
            }
            else if (e.ReportPath == "ExceptionReflexTest" || e.DataSourceNames[0].ToString() == "ExceptionReflexTestDataSet")
            {
                ReportDataSource reportSourceExceptionReflexTest = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionReflexTest.Name = "ExceptionReflexTestDataSet";
                    reportSourceExceptionReflexTest.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportReflexTest.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionReflexTest);
            }
            else if (e.ReportPath == "ExceptionSpecimen" || e.DataSourceNames[0].ToString() == "ExceptionSpecimenDataSet")
            {
                ReportDataSource reportSourceExceptionSpecimen = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionSpecimen.Name = "ExceptionSpecimenDataSet";
                    reportSourceExceptionSpecimen.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportSpecimen.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionSpecimen);
            }
            else if (e.ReportPath == "ExceptionUnitSelection" || e.DataSourceNames[0].ToString() == "ExceptionUnitSelectionDataSet")
            {
                ReportDataSource reportSourceExceptionUnitSelection = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionUnitSelection.Name = "ExceptionUnitSelectionDataSet";
                    reportSourceExceptionUnitSelection.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportUnitSelection.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionUnitSelection);
            }
            else if (e.ReportPath == "ExceptionTrwSpecimen" || e.DataSourceNames[0].ToString() == "ExceptionTrwSpecimenDataSet")
            {
                ReportDataSource reportSourceExceptionTrwSpecimen = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionTrwSpecimen.Name = "ExceptionTrwSpecimenDataSet";
                    reportSourceExceptionTrwSpecimen.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportTrwSpecimen.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionTrwSpecimen);
            }
            else if (e.ReportPath == "ExceptionTransfusionReactionWorkup" || e.DataSourceNames[0].ToString() == "ExceptionTransfusionReactionWorkupDataSet")
            {
                ReportDataSource reportSourceExceptionTransfusionReactionWorkup = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionTransfusionReactionWorkup.Name = "ExceptionTransfusionReactionWorkupDataSet";
                    reportSourceExceptionTransfusionReactionWorkup.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionTransfusionReactionWorkup);
            }
            else if (e.ReportPath == "ExceptionCautionTagBTRFPrinting" || e.DataSourceNames[0].ToString() == "ExceptionCautionTagBTRFPrintingDataSet")
            {
                ReportDataSource reportSourceExceptionCautionTagBTRFPrinting = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionCautionTagBTRFPrinting.Name = "ExceptionCautionTagBTRFPrintingDataSet";
                    reportSourceExceptionCautionTagBTRFPrinting.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionCautionTagBTRFPrinting);
            }
            else if (e.ReportPath == "ExceptionReturnIssuedUnit" || e.DataSourceNames[0].ToString() == "ExceptionReturnIssuedUnitDataSet")
            {
                ReportDataSource reportSourceExceptionReturnIssuedUnit = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionReturnIssuedUnit.Name = "ExceptionReturnIssuedUnitDataSet";
                    reportSourceExceptionReturnIssuedUnit.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionReturnIssuedUnit);
            }
            else if (e.ReportPath == "ExceptionTransfusion" || e.DataSourceNames[0].ToString() == "ExceptionTransfusionDataSet")
            {
                ReportDataSource reportSourceExceptionTransfusion = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionTransfusion.Name = "ExceptionTransfusionDataSet";
                    reportSourceExceptionTransfusion.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportTransfusion.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionTransfusion);
            }
            else if (e.ReportPath == "ExceptionUnitIssue" || e.DataSourceNames[0].ToString() == "ExceptionUnitIssueDataSet")
            {
                ReportDataSource reportSourceExceptionUnitIssue = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionUnitIssue.Name = "ExceptionUnitIssueDataSet";
                    reportSourceExceptionUnitIssue.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportUnitIssue.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionUnitIssue);
            }
            else if (e.ReportPath == "ExceptionEmergencyIssueOrder" || e.DataSourceNames[0].ToString() == "ExceptionEmergencyIssueOrderDataSet")
            {
                ReportDataSource reportSourceExceptionEmergencyIssueOrder = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionEmergencyIssueOrder.Name = "ExceptionEmergencyIssueOrderDataSet";
                    reportSourceExceptionEmergencyIssueOrder.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionEmergencyIssueOrder);
            }
            else if (e.ReportPath == "ExceptionUnitERIssuedTestingProblem" || e.DataSourceNames[0].ToString() == "ExceptionUnitERIssuedTestingProblemDataSet")
            {
                ReportDataSource reportSourceExceptionUnitERIssuedTestingProblem = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionUnitERIssuedTestingProblem.Name = "ExceptionUnitERIssuedTestingProblemDataSet";
                    reportSourceExceptionUnitERIssuedTestingProblem.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionUnitERIssuedTestingProblem);
            }
            else if (e.ReportPath == "ExceptionPatientRestriction" || e.DataSourceNames[0].ToString() == "ExceptionPatientRestrictionDataSet")
            {
                ReportDataSource reportSourceExceptionPatientRestriction = new ReportDataSource();
                if (this._report.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientRestriction.Name = "ExceptionPatientRestrictionDataSet";
                    reportSourceExceptionPatientRestriction.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientRestriction.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientRestriction);
            }
        }

		private void CloseClick(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void PrintClick(object sender, System.EventArgs e)
		{
            //CR 3416 CR 3449
            try
            {
                this.rvPatientHistoryReport.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

        private void FrmPatientRecordReport_Load(object sender, EventArgs e)
        {

            this.rvPatientHistoryReport.RefreshReport();
        }

	}
}

